<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('escolas', function (Blueprint $table) {
            $table->id();
            $table->string('nome',200); 
            $table->string('numerodaescola')->nullable();
            $table->string('nomedoresponsavel',100)->nullable();  
            $table->string('telefonedoresponsavel',100);
            $table->string('emaildoresponsavel',80)->nullable();
            $table->string('logotipo')->nullable();
            $table->foreignId('municipio_id')->constrained()->cascadeOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('escolas');
    }
};
